
#include <ldap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "DirectoryService.h"



int main( )
	{

NamingContext	*dsi	= NULL;

AttributeInfo	**attrs		= NULL;

AttributeInfo	**reslis	= NULL;
char		 *res_s		= NULL;

AttributeInfo	**bas		= NULL;
AttributeInfo	*attribute	= NULL;

int		ridx		= 0;

BOOLEAN		insertedOK	= FALSE;


	dsi	= ndi_ldap_Create( "O=SEB", "SEB177" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( getStatus( ) .. 

	ndi_ldap_simpleBind( dsi, "SEBUI=X12348,O=SEB", "ldaptest" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "\n--------------- Get list of current attributes ---------------------\n");

	reslis	= ndi_ldap_getListByDN( dsi, "SEBUI=X12348" );

	if ( reslis != NULL )
	    {
	    ridx	= 0;
	    while ( reslis[ ridx ] != NULL )
		{
		printf( "Idx = %3d = %s\n", ridx, reslis[ ridx ]->t_val );

		if ( reslis[ ridx ]->v_len != 0 )
		    {
		    printf( "\t%s\n", reslis[ ridx ]->v_val );
		    }
		  else
		    {
		    printf( "<No Value>\n" );
		    }

		ridx++;
		}				// while ( )
	    }
	  else
	    {
	    printf( "NULL returned from LDAP\n" );

	    if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
		{
		printf( "%s\n", ndi_ldap_getMessage1( dsi ));
		printf( "%s\n", ndi_ldap_getMessage2( dsi ));
		}				// if ( ndi_ldap_getStatus( dsi ) .. 
	    }

	printf( "\n--------------- Get list of attribute 'telephoneNumber' ---------------------\n");

	res_s	= NULL;

	res_s	= ndi_ldap_getAttrValueByDN( dsi, "SEBUI=X12348", "telephoneNumber" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "Result for telephoneNumber = %s\n", res_s );


	printf("\n--------------- Modify attribute 'rfc822Mailbox' ---------------------\n");

	res_s	= ndi_ldap_getAttrValueByDN( dsi, "SEBUI=X12348", "rfc822Mailbox" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "Result before modify of rfc822Mailbox = %s\n", res_s );

	printf("\n--------------- Add attribute 'rfc822Mailbox' ---------------------\n");

	attrs		= NULL;
	attribute	= NULL;

	attrs	= ( AttributeInfo ** ) calloc( 1 + 1, sizeof( AttributeInfo * ));

	attribute	= malloc( sizeof( AttributeInfo ));

	attribute->t_val	= "rfc822Mailbox";
	attribute->v_val	= "test.user@seb.se";
	attribute->v_len	= strlen( attribute->v_val );

	attrs[ 0 ]	= attribute;

	ndi_ldap_addAttrByDN( dsi, "SEBUI=X12348", attrs  );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	res_s	= ndi_ldap_getAttrValueByDN( dsi, "SEBUI=X12348", "rfc822Mailbox" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "Result for rfc822Mailbox after insert = %s\n", res_s );

	printf("\n--------------- Modify previously inserted attribute 'rfc822Mailbox' ---------------------\n");

	attribute->t_val	= "rfc822Mailbox";
	attribute->v_val	= "info@seb.se";
	attribute->v_len	= strlen( attribute->v_val );

	attrs[ 0 ]	= attribute;

	ndi_ldap_modifyAttrByDN( dsi, "SEBUI=X12348", attrs  );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	res_s	= ndi_ldap_getAttrValueByDN( dsi, "SEBUI=X12348", "rfc822Mailbox" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "Result for rfc822Mailbox after modify = %s\n", res_s );

	printf("\n--------------- Remove attribute 'rfc822Mailbox' ---------------------\n" );

	ndi_ldap_removeAttrByDN( dsi, "SEBUI=X12348", attrs  );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	ndi_ldap_freeAttributeInfo( attrs );

	res_s	= ndi_ldap_getAttrValueByDN( dsi, "SEBUI=X12348", "rfc822Mailbox" );

	if ( ndi_ldap_getStatus( dsi ) != RS_LDAP_OK )
	    {
	    printf( "%s\n", ndi_ldap_getMessage1( dsi ));
	    printf( "%s\n", ndi_ldap_getMessage2( dsi ));
	    }					// if ( ndi_ldap_getStatus( ) .. 

	printf( "Result for rfc822Mailbox after remove = %s\n", res_s );

	printf("\n--------------- Close directory ---------------------\n");

	ndi_ldap_close( dsi );

	}
