//
// NOTE !	The use of "return status codes" is made making this
//		equal to the Java functions used
//

#define		RS_LDAP_UNDEFINED	0
#define		RS_LDAP_OK		1
#define		RS_LDAP_INIT_FAIL	2
#define		RS_LDAP_INVALID_UID	3	// Invalid User ID
#define		RS_LDAP_INVALID_PWD	4	// Invalid Password
#define		RS_LDAP_BIND_FAIL	5	// Failed to 'bind' to LDAP server
#define		RS_LDAP_GET_ATTR_FAIL	6	// Failed to retrieve attribute(s)
#define		RS_LDAP_SEARCH_AMBIGUOUS	7	// Search for RDN returned more than one result
#define		RS_LDAP_SEARCH_FAIL	8	// Search failed ( general fail )
#define		RS_LDAP_ATTR_AMBIGUOUS	9	// Result for retrieval of one attribute returned more than one
#define		RS_LDAP_ENTRY_EXISTS	10	// The specified entry exists when trying to insert
#define		RS_LDAP_INVALID_ATTR	11	// One or more attributes invalid or conflicting
#define		RS_LDAP_INSERT_FAIL	12	// The insertion ( add ) of entry failed
#define		RS_LDAP_NO_ENTRY	13	// The specified entry does not exists when trying to remove
#define		RS_LDAP_REMOVE_FAIL	14	// The removal of an entry failed
#define		RS_LDAP_ATTR_MOD_FAIL	15	// The modification of an existing attribute failed
#define		RS_LDAP_ATTR_ADD_FAIL	16	// The insertion of an attribute failed
#define		RS_LDAP_ATTR_REM_FAIL	17	// The removal of an attribute failed
#define		RS_LDAP_NO_ATTR		18	// The specified attribute does not exists


#define	MAX_ATTRIBUTES	100			// Maximum number of handled attributes for an entry


//
//	Internal definitions
//
//	Size definitions for varous work areas
//
#define	DN_AREA_SIZE	200			// The size of the internal DN work area
#define	MESSAGE_AREA_SIZE	500		// The size of the Message work areas
#define FILTER_AREA_SIZE	1000		// Maximum length of the filter area

typedef	char DN_Area[ DN_AREA_SIZE ];


//
//	The AttributeInfo structure is used when passing attribute values
//	between user code and LDAP support routines.
//
//	This structure is always dynamically allocated when passing information
//	from the LDAP routines to the user. The user must do the proper
//	deallocation of all areas. When passing data from user to LDAP
//	routines the user may use static areas as well as dynamic.
//	In case of dynamic areas user must release the areas uppon return

//----

typedef struct attrinfo
	{
	char	*t_val;
        int	v_len;
	char	*v_val;
	} AttributeInfo;

// ----

typedef int	BOOLEAN;

#define	TRUE	1
#define	FALSE	0

//
//	The NamingContext structure is used to keep information
//	needed for the calls to the underlying LDAP structure
//
typedef struct namctx
	{
	LDAP	*ldapCtx_;

	char	*searchBase_;
	char	*ldapServer_;

	int	ldapStatus_;
	int	ldapProtocol;

	BOOLEAN	Bound_;

	FILE	*ldapTrace_;

	char	*ldapStatusMsg1_;
	char	*ldapStatusMsg2_;
	} NamingContext;


//
// NOTE ! The search base string is always appended to the search string given
//	  for every search. If search base is O=SEB and You specify CN=Jonny, the resulting search
//	  would be CN=Jonny,O=SEB else it would be only O=SEB

//
// NOTE ! All returned strings are dynamically allocated and must be freed
//	  All returned AttributeInfo structures must be freed using the
//	  ndi_ldap_freeAttributeInfo( ) function


//
//	ndi_ldap_Create
//
//	Creates the needed internal datastructures needed for the handling of
//	user requests. No call to the LDAP service is actually done
//
//	Args:	sb	String containing the specified search base
//		server	String containing the name of the ldap server host
//			like SEB500 or SEB500.SEBANK.SE
//
//	Return:	dsi	Pointer to the NamingContext area
//
//	Status handling by the ndi_ldap_getStatus( )
//
NamingContext	*ndi_ldap_Create( const char *sb, const char *server );

//
//	ndi_ldap_SetTraceFile
//
//	Creates the needed internal datastructures needed for the handling of
//	user requests. No call to the LDAP service is actually done
//	Messages from the DirectoryService methods are written to the specified file
//	which must be opened & closed by the user
//
//	Args:	sb	String containing the specified search base
//		server	String containing the name of the ldap server host
//			like SEB500 or SEB500.SEBANK.SE
//		lto	Pointer to a  file opend for output
//
//	Return:	dsi	Pointer to the NamingContext area
//
//	Status handling by the ndi_ldap_getStatus( )
//
NamingContext	*ndi_ldap_SetTraceFile( const char *sb, const char *server, FILE *lto );

//
//	ndi_ldap_EnableTrace
//
//	Creates the needed internal datastructures needed for the handling of
//	user requests. No call to the LDAP service is actually done
//	Trace & error messages may be written to stderr
//
//	Args:	sb	String containing the specified search base
//		server	String containing the name of the ldap server host
//			like SEB500 or SEB500.SEBANK.SE
//		tflag	Boolean indicating that trace should or should not
//			be performed to stderr
//
//	Return:	dsi	Pointer to the NamingContext area
//
//	Status handling by the ndi_ldap_getStatus( )
//
NamingContext	*ndi_ldap_EnableTrace( const char *sb, const char *server, BOOLEAN tflag );

//
//	simpleBind
//
//	The method acts as an connect/reconnect to the LDAP Service.
//	It handles calls for the LDAP bind function and authentication
//	The uid should be fully distinguished and pwd is case sensitive
//	The uid and / or the pwd may be null 
//
//	Args:	uid	String containing the DN to bind with
//		pwd	String containing the password for the DN
//
//	Return:	True	Bind was succesfull
//		False	Bind failed
//
//	Status handling by the ndi_ldap_getStatus( )
//
BOOLEAN ndi_ldap_simpleBind( NamingContext *dsi, const char *uid, const char *pwd );

//
//	ndi_ldap_getListByDN
//
//	Search for a specific entry using a specified DN like CN=Fullname,O=SEB and
//	retrieve all available attributes as a list
//	It returns all attributes found ( except the password attribute ), operational
//	attributes are not returned
//
//	Args:	nam_s	String containing the DN to get attributes for
//
//	Return:		Pointer to an Attribute Info array
//			If nothing found a NULL is returned or if any error
//
//	Status handling by the ndi_ldap_getStatus( )
//
AttributeInfo **ndi_ldap_getListByDN( NamingContext *dsi, const char *nam_s );

//
//	ndi_ldap_getDNFromAttr
//
//	Search for a specific entry using a list of attributes containing
//	type & value pairs. This is mainly used to get the DN for a entry
//	which is to be used later in calls.
//
//	Args:	nam_s	String with additions to the search base, normaly len = 0
//		bas_a	AttributeInfo array containing the attributes to
//			find the DN for
//
//	Return:		Pointer to a string with the DN if found
//			NULL if any error
//
//	Status handling by the ndi_ldap_getStatus( )
//
char *ndi_ldap_getDNFromAttr( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a );

//
//	ndi_ldap_getAttrValueByDN
//
//	Retrieves the value for a specified attribute in a specified entry
//	using the DN like CN=Fullname,O=SEB.
//
//	NOTE !	If the attribute search requested returns a valid result
//		but not any attribute value like the password attribute,
//		an empty attribute value is returned
//	NOTE ! This works only with nonbinary strings
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		attr_s	String containing the attribute to return a value for
//
//	Return:		Pointer to a string with the attribute value if found
//			NULL if any error
//
//	Status handling by the ndi_ldap_getStatus( )
//
char *ndi_ldap_getAttrValueByDN( NamingContext *dsi, const char *nam_s, const char *attr_s );

//
//	ndi_ldap_getAttrByDN
//
//	Get a attribute structure containing the type & value pair using
//	a DN like CN=Fullname,O=SEB. Works also with binary values.
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		attr_s	String containing the attribute to return
//
//	Return:		Pointer to an AttributeInfo structure
//			NULL if any error
//
//	Status handling by the ndi_ldap_getStatus( )
//
AttributeInfo *ndi_ldap_getAttrByDN( NamingContext *dsi, const char *nam_s, const char *attr_s );

//
//	ndi_ldap_addEntryWithAttrs( )
//
//	Adds ( creates ) a new entry using a DN like CN=Fullname,O=SEB and
//	a list of attribute pairs. All attribute pairs must be set up by
//	the user with the correct values.
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		bas_a	AttributeInfo structure containing ALL attributes
//			for the entry
//
//	Return:	TRUE	Entry was added
//		FALSE	The entry was not added
//
//	Status handling by the ndi_ldap_getStatus( )
//
BOOLEAN ndi_ldap_addEntryWithAttrs( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a );

//
//	ndi_ldap_removeEntryByDN
//
//	Removes an entry using a DN like CN=Fullname,O=SEB. Subentries
//	will also be deleted.
//
//	Args:	nam_s	String with a DN without the defined searchbase
//
//	Return:	TRUE	Entry was removed
//		FALSE	The entry was not removed
//
BOOLEAN ndi_ldap_removeEntryByDN( NamingContext *dsi, const char *nam_s );

//
//	ndi_ldap_modifyAttrByDN
//
//	Modifies an attribute for a specified entry using a DN and
//	a list of Attributes to be modified. Valid attributes not already
//	in entry is added to the entry.
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		bas_a	AttributeInfo structure containing attributes
//			to modify for the entry
//
//	Return:	TRUE	Entry was added
//		FALSE	The entry was not added
//
BOOLEAN ndi_ldap_modifyAttrByDN( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a );

//
//	ndi_ldap_removeAttrByDN
//
//	Remove an attribute in an entry specified by a DN and a list of
//	attributes to remove.The selected attributes must exists
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		bas_a	AttributeInfo structure containing attributes
//			to be removed
//
//	Return:	TRUE	Entry was removed
//		FALSE	The entry was not removed
//
BOOLEAN ndi_ldap_removeAttrByDN( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a );

//
//	ndi_ldap_addAttrByDN
//
//	Add an attribute or attributes to an entry specified by a DN and
//	a list of Attributes. The selected attributes must NOT exists
//
//	NOTE ! Partial insert is possible
//
//	Args:	nam_s	String with a DN without the defined searchbase
//		bas_a	AttributeInfo structure containing attributes
//			to add for the entry
//
//	Return:	TRUE	Attributes was added
//		FALSE	The attributes was not added
//
BOOLEAN ndi_ldap_addAttrByDN( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a );

//
//	ndi_ldap_getListByAttrs
//
//	Retrieves all attributes from an entry selected by the passed
//	attribute pairs.
//	It returns all attributes found ( except the password attribute )
//	If nothing found a NULL is returned
//
//	Args:	nam_s	String to add to searchbase, normaly len = 0
//		bas_a	AttributeInfo structure containing attributes
//			to search for
//
//	Return:		If found an AttributeInfo structure is returned
//			NULL if any error
//
AttributeInfo **ndi_ldap_getListByAttrs( NamingContext *dsi, const char *nam_s, AttributeInfo *bas_a[ ] );

//
//	ndi_ldap_getAttrValueByAttr
//
//	Returns the value of a selected attribute from an antry specified by
//	a list of attribute pairs.
//
//	Returns the specified attribute value string if found else NULL
//
//	NOTE ! Works only with nonbinary values
//
//	Args:	nam_s	String to add to the searchBase, normaly len = 0
//		bas_a	AttributeInfo structure containing attributes
//			specifying the search.
//		attr_s	The attribute value to return
//
//	Return:		Pointer to an attribute value string
//			NULL if any error
//
char *ndi_ldap_getAttrValueByAttr( NamingContext *dsi, const char *nam_s, AttributeInfo *bas_a[ ], const char *attr_s );

//
//	ndi_ldap_getAttrByAttr
//
//	Get a specified attribute from an entry selected by a list of attribute pairs.
//
//	Returns the specified attribute if found else NULL
//
//	Args:	nam_s	String to add to the search base, normaly len = 0
//		bas_a	AttributeInfo structure containing attributes
//			to specify the search
//		attr_s	The attribute to return
//
//	Return:		A pointer to an AttributeInfor structure
//			NULL if any error
//
AttributeInfo *ndi_ldap_getAttrByAttr( NamingContext *dsi, const char *nam_s, AttributeInfo **bas_a, const char *attr_s );

//
//	ndi_ldap_removeSearchBase
//
//      Since the DN returned by getDN... contains also the search base
//      and that should not be included when passing a DN as a base for
//      a search, this method removes the search base from the DN and also
//      the preceeding ","
//
//	Args:	dn_s	Pointer to the DB string containing the search base
//
//	Return:	*	A pointer to the DN without search base if found
//			else NULL;
//
char *ndi_ldap_removeSearchBase( NamingContext *dsi, const char *dn_s );

//
//	ndi_ldap_setFollowReferral
//
//	It will if TRUE set the referral flag to follow else it will
//	be set to "ignore" wich is the standard
//	The flag must be set to TRUE before performing writes or updates to
//	the directory
//
//	Args:	flag	If TRUE set to follow referrals
//			if FALSE set to NOT follow referrals
//
//	Return:	TRUE	Was set
//		FALSE	Was not set
//
BOOLEAN ndi_ldap_setFollowReferral( NamingContext *dsi, BOOLEAN flag );

//
//	ndi_ldap_freeAttributeInfo
//
//	Free the attribute info structure
//
//	Args:	bas_a	AttributeInfo structure to free
//
//	Return:		Always success
//
void ndi_ldap_freeAttributeInfo( AttributeInfo **bas_a );

//
//	ndi_ldap_getLDAPCtx
//
//	Returns a pointer to the internal LDAP context. To be used if the
//	DirectoryService package could not fullfill the requirements of
//	the user. This pointer is used when calling standard LDAP functions
//
//	Input:	NONE
//
//	Return:		Pointer to the internal LDAP context block.
//
//
LDAP	*ndi_ldap_getLDAPCtx( NamingContext *dsi );

//
//	ndi_ldap_getStatus
//
//	Returns the last set status code
//
//	Input:	NONE
//
//	Return:		The current internal status code ( RS_LDAP_.. )
//
int	ndi_ldap_getStatus( NamingContext *dsi );

//
//	ndi_ldap_isNotBound
//
//	Returns wether or not a LDAP server has been bound
//
//	Input:	NONE
//
//	Return:		TRUE if bound
//			FALSE if not bound
//
BOOLEAN	ndi_ldap_isNotBound( NamingContext *dsi );

//
//	ndi_ldap_getMessage1
//
//	Returns the current error message. Valid only if status is not RS_LDAP_OK
//	or RD_LDAP_UNDEFINED
//
//	Input:	NONE
//
//	Return:		Pointer to character string
//
//	NOTE !		Should not be freed
//
char *ndi_ldap_getMessage1( NamingContext *dsi );

//
//	ndi_ldap_getMessage2
//
//	Returns the option error message. Valid only if status is not RS_LDAP_OK
//	or RD_LDAP_UNDEFINED
//
//	Input:	NONE
//
//	Return:		Pointer to character string if otional message is defined in LDAP
//
//	NOTE !		Should not be freed
//
char *ndi_ldap_getMessage2( NamingContext *dsi );

//
//  FUNCTION:
//	
//	ndi_ldap_str_to_upper
//
//  FUNCTIONAL DESCRIPTION:
//
//	This routine converts a character string to uppercase. It is a copy
//	of the ge_str_to_upper( ) from GE
//	
//  PROCESSING:
//
//	Convert character by character to uppercase until NULL is found
//
//  FORMAL PARAMETERS:
//    
//	char  *str     Pointer to a null terminated string
//
//  RETURN VALUE:
//
//	none
//
//  CALLING SEQUENCE:
//   
//      
//  
//  AUTHOR:
//
//      Tom Svaleklev, SEB Data                    6-MAR-1991
// 
void ndi_ldap_str_to_upper( char *str);

//
//	ndi_ldap_close
//
//	Will close all connections to the bound server. All internal
//	structures are freed and any call to the service after this call
//	is invalid and will return unpredictable results.
//
//	Input:	NONE
//
//	Return:	NONE
//
void	ndi_ldap_close( NamingContext *dsi );
